//
//  RMImage.h
//  RMAppKit
//
//  Created by Keith Duncan on 27/09/2012.
//  Copyright (c) 2012 Realmac Software. All rights reserved.
//

#import <TargetConditionals.h>

#import <Foundation/Foundation.h>

#if !TARGET_OS_IPHONE
#import <AppKit/AppKit.h>
#else
#import <UIKit/UIKit.h>
#endif /* !TARGET_OS_IPHONE */

#import "RMFoundation/RMFoundation.h"

/*
	\brief
	Symbolic constants for the values of the kCGImagePropertyOrientation property
	
	1 = 0th row is at the top, and 0th column is on the left.
	2 = 0th row is at the top, and 0th column is on the right.
	3 = 0th row is at the bottom, and 0th column is on the right.
	4 = 0th row is at the bottom, and 0th column is on the left. 
	5 = 0th row is on the left, and 0th column is the top.
	6 = 0th row is on the right, and 0th column is the top.
	7 = 0th row is on the right, and 0th column is the bottom.
	8 = 0th row is on the left, and 0th column is the bottom.
 */
typedef RM_ENUM(NSUInteger, RMImageOrientation) {
	RMImageOrientationTopLeft = 1,
	RMImageOrientationTopRight = 2,
	RMImageOrientationBottomRight = 3,
	RMImageOrientationBottomLeft = 4,
	RMImageOrientationLeftTop = 5,
	RMImageOrientationRightTop = 6,
	RMImageOrientationRightBottom = 7,
	RMImageOrientationLeftBottom = 8,
};

#if TARGET_OS_IPHONE

/*!
	\brief
	Convert from a kCGImagePropertyOrientation value to UIImageOrientation
 */
extern UIImageOrientation RMImageUIImageOrientationForCGImageOrientation(NSInteger CGImageOrientation);

/*!
	\brief
	Convert from UIImageOrientation to a kCGImagePropertyOrientation value
 */
extern NSInteger RMImageCGImageOrientationForUIImageOrientation(UIImageOrientation UIImageOrientation);

#endif /* TARGET_OS_IPHONE */

/*!
	\brief
	Extract the transform for a standalone image, the image will be in `RMImageOrientationTopLeft` orientation afterwards
	
	\details
	The transform also ensures the image's origin is {0, 0} after the effect
 */
extern CGAffineTransform RMImageOrientationNormalisingTransformForOrientation(CGSize imageSize, RMImageOrientation orientation);

/*!
	\brief
	For services that don't interpret the TIFF orientation correctly, we adjust the image ourselves.
	
	\return
	NO if the image doesn't contain orientation data and doesn't need to be normalised, or the image couldn't be written to the provided location
	YES if a normalised image was written to the `destinationLocation`
 */
extern BOOL RMImageWriteImageWithNormalisedOrientationToURL(NSURL *existingLocation, NSURL *destinationLocation);
